<?php
$CI = get_instance();
$CI->load->database();
$CI->load->dbforge();


$notification_settings = array(
    'type' => 'instructor_followups',
    'is_editable' => '1',
    'addon_identifier' => '',
    'user_types' => '["student"]',
    'system_notification' => '{"student":"1"}',
    'email_notification' => '{"student":"0"}',
    'subject' => '{"student":"Instructor followups"}',
    'template' => '{"student":"Hi, You have a new notice by [instructor_name]. The course [course_title]"}',
    'setting_title' => 'Instructor followups',
    'setting_sub_title' => 'Notify to enrolled students when announcements are created by the instructor for a particular course.',
    'date_updated' => '1699525375'
);
$CI->db->insert('notification_settings', $notification_settings);

$notification_setting = array(
    'type' => 'instructor_followups_reminder',
    'is_editable' => '1',
    'addon_identifier' => '',
    'user_types' => '["instructor"]',
    'system_notification' => '{"instructor":"1"}',
    'email_notification' => '{"instructor":"0"}',
    'subject' => '{"instructor":"Follow-up of student"}',
    'template' => '{"instructor":"Hi, You have a new follow by [student_name]."}',
    'setting_title' => 'Instructor followups',
    'setting_sub_title' => 'When any student follows an instructor, the instructor should receive a notification.',
    'date_updated' => '1699525375'
);
$CI->db->insert('notification_settings', $notification_setting);


// CREATING instructor_followings TABLE
$instructor_followings = array(
    'id' => array(
        'type' => 'INT',
        'constraint' => 11,
        'unsigned' => TRUE,
        'auto_increment' => TRUE,
        'collation' => 'utf8_unicode_ci'
    ),
    'user_id' => array(
        'type' => 'INT',
        'constraint' => 11,
        'null' => TRUE,
        'collation' => 'utf8_unicode_ci'
    ),
    'instructor_id' => array(
        'type' => 'INT',
        'constraint' => 11,
        'null' => TRUE,
        'collation' => 'utf8_unicode_ci'
    ),
    'is_following' => array(
        'type' => 'INT',
        'constraint' => 11,
        'null' => TRUE,
        'collation' => 'utf8_unicode_ci'
    ),
    'created_at' => array(
        'type' => 'varchar',
        'constraint' => 100,
        'collation' => 'utf8_unicode_ci'
    ),
    'updated_at' => array(
        'type' => 'varchar',
        'constraint' => 100,
        'collation' => 'utf8_unicode_ci'
    )
);
$CI->dbforge->add_field($instructor_followings);
$CI->dbforge->add_key('id', TRUE);
$attributes = array('collation' => "utf8_unicode_ci");
$CI->dbforge->create_table('instructor_followings', TRUE);






//Water Mark  
if($CI->db->get_where('frontend_settings', ['key' => 'water_mark'])->num_rows() == 0){
	$CI->db->insert('frontend_settings', ['key' => 'water_mark', 'value' => '']);
}
if($CI->db->get_where('frontend_settings', ['key' => 'water_mark_status'])->num_rows() == 0){
	$CI->db->insert('frontend_settings', ['key' => 'water_mark_status', 'value' => '']);
}
//Public SignUp 
if($CI->db->get_where('settings', ['key' => 'public_signup'])->num_rows() == 0){
	$CI->db->insert('settings', ['key' => 'public_signup', 'value' => 'enable']);
}

// update VERSION NUMBER INSIDE SETTINGS TABLE
$settings_data = array('value' => '6.10');
$CI->db->where('key', 'version');
$CI->db->update('settings', $settings_data);